/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils.floodfill;

import earth.terrarium.adastra.common.blocks.SlidingDoorBlock;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;

public final class FloodFill3D {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    public static final SolidBlockPredicate TEST_FULL_SEAL = (level, pos, state, positions, queue, direction) -> {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26164(ModBlockTags.PASSES_FLOOD_FILL)) {
            return true;
        }
        if (state.method_26164(ModBlockTags.BLOCKS_FLOOD_FILL)) {
            return false;
        }
        if (state.method_26234((class_1922)level, pos)) {
            return false;
        }
        class_265 collisionShape = state.method_26220((class_1922)level, pos);
        class_2248 patt1354$temp = state.method_26204();
        if (patt1354$temp instanceof SlidingDoorBlock) {
            SlidingDoorBlock block = (SlidingDoorBlock)patt1354$temp;
            collisionShape = block.method_9549(state, (class_1922)level, pos, class_3726.method_16194());
        }
        if (collisionShape.method_1110()) {
            return true;
        }
        if (!FloodFill3D.isSideSolid(collisionShape, direction)) {
            return true;
        }
        if (!FloodFill3D.isFaceSturdy(collisionShape, direction) && !FloodFill3D.isFaceSturdy(collisionShape, direction.method_10153())) {
            return true;
        }
        for (class_2350 dir : DIRECTIONS) {
            class_2338 adjacentPos;
            class_2680 adjacentState;
            if (dir.method_10166() == direction.method_10166() || !(adjacentState = level.method_8320(adjacentPos = pos.method_10093(dir))).method_26215()) continue;
            return true;
        }
        positions.add(pos.method_10063());
        return false;
    };

    public static Set<class_2338> run(class_1937 level, class_2338 start, int limit, SolidBlockPredicate predicate, boolean retainOrder) {
        level.method_16107().method_15396("adastra-floodfill");
        LongLinkedOpenHashSet positions = retainOrder ? new LongLinkedOpenHashSet(limit) : new LongOpenHashSet(limit);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue(limit);
        queue.enqueue(start.method_10063());
        while (!queue.isEmpty() && positions.size() < limit) {
            long packedPos = queue.dequeueLong();
            if (positions.contains(packedPos)) continue;
            positions.add(packedPos);
            class_2338.class_2339 pos = new class_2338.class_2339(class_2338.method_10061((long)packedPos), class_2338.method_10071((long)packedPos), class_2338.method_10083((long)packedPos));
            for (class_2350 direction : DIRECTIONS) {
                pos.method_16363(packedPos);
                pos.method_10098(direction);
                class_2680 state = level.method_8320((class_2338)pos);
                if (!predicate.test(level, (class_2338)pos, state, (LongSet)positions, queue, direction)) continue;
                queue.enqueue(pos.method_10063());
            }
        }
        LinkedHashSet<class_2338> result = retainOrder ? new LinkedHashSet(positions.size()) : new HashSet(positions.size());
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            result.add(class_2338.method_10092((long)pos));
        }
        level.method_16107().method_15407();
        return result;
    }

    private static boolean isSideSolid(class_265 collisionShape, class_2350 dir) {
        return switch (dir.method_10166()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> FloodFill3D.isAxisCovered(collisionShape, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051);
            case class_2350.class_2351.field_11052 -> FloodFill3D.isAxisCovered(collisionShape, class_2350.class_2351.field_11048, class_2350.class_2351.field_11051);
            case class_2350.class_2351.field_11051 -> FloodFill3D.isAxisCovered(collisionShape, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052);
        };
    }

    private static boolean isAxisCovered(class_265 shape, class_2350.class_2351 axis1, class_2350.class_2351 axis2) {
        return shape.method_1091(axis1) <= 0.0 && shape.method_1105(axis1) >= 1.0 && shape.method_1091(axis2) <= 0.0 && shape.method_1105(axis2) >= 1.0;
    }

    private static boolean isFaceSturdy(class_265 collisionShape, class_2350 dir) {
        class_265 faceShape = collisionShape.method_20538(dir);
        if (faceShape.method_1110()) {
            return true;
        }
        List aabbs = faceShape.method_1090();
        if (aabbs.isEmpty()) {
            return true;
        }
        return FloodFill3D.checkBounds((class_238)aabbs.get(0), dir.method_10166());
    }

    private static boolean checkBounds(class_238 bounds, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (bounds.field_1322 <= 0.0 && bounds.field_1325 >= 1.0 && bounds.field_1321 <= 0.0 && bounds.field_1324 >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11052 -> {
                if (bounds.field_1323 <= 0.0 && bounds.field_1320 >= 1.0 && bounds.field_1321 <= 0.0 && bounds.field_1324 >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11051 -> bounds.field_1323 <= 0.0 && bounds.field_1320 >= 1.0 && bounds.field_1322 <= 0.0 && bounds.field_1325 >= 1.0;
        };
    }

    @FunctionalInterface
    public static interface SolidBlockPredicate {
        public boolean test(class_1937 var1, class_2338 var2, class_2680 var3, LongSet var4, LongArrayFIFOQueue var5, class_2350 var6);
    }
}

